/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.google.common.util.concurrent.RateLimiter;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.displayentity.DisplayEntityManipulator;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.packets.AxiomClientboundRestrictions;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.utils.Box;
import java.util.List;

public class Restrictions {
    public static boolean canImportBlocks = true;
    public static boolean canUseEditor = true;
    public static boolean canEditDisplayEntities = true;
    public static RateLimiter rateLimiter = null;
    public static List<Box> bounds = List.of();
    public static Box globalBounds = null;

    public static void update(AxiomClientboundRestrictions restrictions) {
        if (canImportBlocks && !restrictions.canImportBlocks) {
            Clipboard.INSTANCE.clearClipboard();
        }
        if (EditorUI.isActive() && !restrictions.canUseEditor) {
            EditorUI.toggleEnabled();
        }
        if (DisplayEntityManipulator.hasActiveGizmo() && !restrictions.canEditDisplayEntities) {
            DisplayEntityManipulator.disableActive();
        }
        canImportBlocks = restrictions.canImportBlocks;
        canUseEditor = restrictions.canUseEditor;
        canEditDisplayEntities = restrictions.canEditDisplayEntities;
        if (restrictions.maxSectionsPerSecond <= 0) {
            rateLimiter = null;
        } else if (rateLimiter != null) {
            rateLimiter.setRate((double)restrictions.maxSectionsPerSecond);
        } else {
            rateLimiter = RateLimiter.create((double)restrictions.maxSectionsPerSecond);
        }
        bounds = restrictions.bounds;
        globalBounds = restrictions.globalBounds;
    }

    public static SelectionBuffer constrainSelection(SelectionBuffer selectionBuffer) {
        if (!bounds.isEmpty()) {
            if (bounds.size() == 1) {
                Box bounds = Restrictions.bounds.get(0);
                selectionBuffer = selectionBuffer.intersectAABB(bounds.pos1(), bounds.pos2(), false);
            } else {
                ChunkedBooleanRegion chunkedBooleanRegion = new ChunkedBooleanRegion();
                selectionBuffer.forEach((x, y, z) -> {
                    for (Box bound : bounds) {
                        if (bound.pos1().method_10263() > x || bound.pos2().method_10263() < x || bound.pos1().method_10264() > y || bound.pos2().method_10264() < y || bound.pos1().method_10260() > z || bound.pos2().method_10260() < z) continue;
                        chunkedBooleanRegion.add(x, y, z);
                    }
                });
                selectionBuffer.close();
                selectionBuffer = new SelectionBuffer.Set(chunkedBooleanRegion);
            }
            return selectionBuffer.optimize();
        }
        return selectionBuffer;
    }

    public static void reset() {
        canImportBlocks = true;
        canUseEditor = true;
        canEditDisplayEntities = true;
        rateLimiter = null;
        bounds = List.of();
        globalBounds = null;
    }
}

